/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// The originals of these shaders did not take gl_FragCoord.w  into
// account so the iStripper scale attribute would  have  no  effect
// when used ina scene node that used one of them. I have therefore
// performed a global replace to substitute scaled_gl_FragCoord for
// gl_FragCoord and declare it here. TheEmu 2016/12/15

#define scaled_gl_FragCoord vec4(gl_FragCoord.xyz*gl_FragCoord.w,1.0)

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse vec2(0.0,0.0)
#define surfacePosition vec2(2.0*scaled_gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

#ifdef GL_ES
precision mediump float;
#endif

// uniform float time;           // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;           // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution;      // Replaced for VGHD by defines above. TheEmu.
// varying vec2 surfacePosition; // Replaced for VGHD by defines above. TheEmu.
#define p surfacePosition

#define PI 3.14159265358979
#define N 50
void main( void ) {
	float size = sin(time-1.8*length(128.*p*p*p*p/length(p)))*.02+0.022;
	float dist = 0.1;
	float ang = time;
	vec2 pos = vec2(0.0,0.0);
	vec3 color = vec3(0.0);
	float r = cos(time)*0.2+.2;
	for(int i=0; i<N; i++){
		ang += PI / (float(N)/2.);
		pos = vec2(sin(ang + float(N))*r,cos(ang + float(N))*r);
		dist += size / distance(pos,vec2(surfacePosition.x+0.,surfacePosition.y+0.));
		vec3 c = vec3(0.1,0.2,0.3);
		color = c*dist;
	}
	gl_FragColor = vec4(color, 1.0);
   gl_FragColor *= gl_Color; // TheEmu 2016/12/15
}